﻿
/////////////////////////////////////////////////////////////
//  Created by Zetta LLC @ AdobeScripting.com              //
//  Northfield MN, USA  Ph: 952-232-0211                   //
//  Email: Info@AdobeScripting.com                         //
//  Copyright: (c) 2015 Zetta LLC                          //
//  Authors:  Sandra Voelker   sandra@AdobeScripting.com   //
//            Sam Gannaway     sam@AdobeScripting.com      //
//  Original Creation date: February  2015                 //
/////////////////////////////////////////////////////////////


function liquifyAction(extPath)
{
    loadLiquifyActionFile(extPath);
    try
    {
        app.doAction('Liquify', 'Liquify CC2014');
        } catch (e)
    {;}
    deleteLiquifyActionSet();
}

function popLiquify(extPath)
{
	app.activeDocument.suspendHistory("Liquify", "liquifyAction('"+extPath+"')");
}

function deleteLiquifyActionSet()
{
    try
    {
        var idDlt = charIDToTypeID( "Dlt " );
        var desc3 = new ActionDescriptor();
        var idnull = charIDToTypeID( "null" );
            var ref1 = new ActionReference();
            var idASet = charIDToTypeID( "ASet" );
            ref1.putName( idASet, "Liquify CC2014" );
        desc3.putReference( idnull, ref1 );
        executeAction( idDlt, desc3, DialogModes.NO );
    } catch (e)
{;}
}

function loadLiquifyActionFile(basePath)
{
    var actionFile = new File(basePath + '/jsx/' + 'LiquifyCC2014.atn');
    app.load(actionFile);
}


//---------------------------
function whatTool() {
    var ref = new ActionReference();
    ref.putProperty( charIDToTypeID( 'Prpr' ), charIDToTypeID( 'Tool' ) );
    ref.putEnumerated( charIDToTypeID( 'capp' ),  charIDToTypeID( 'Ordn' ), charIDToTypeID( 'Trgt' ) );
    var desc = executeActionGet( ref );
    var theTool = desc.getEnumerationType( charIDToTypeID( 'Tool' ) );
    var s = '<object>';
    var result = typeIDToStringID( theTool );
    s += PropertyToXML(result, 'tool');
    s += '</object>';
    return s;
}


//---------------------------
function getToolCharStringID(indescIDFromSWF)
{
    try {
        //convert the string from SWF to a number
        var id = Number(indescIDFromSWF); 
        var desc = new ActionDescriptor();
        desc.fromID(id);
        var idNull = charIDToTypeID('null');
        var ref = desc.getReference(idNull);
        var toolID = ref.getDesiredClass();
        //use this to compare against spotHealingBrushTool
        var stringID = typeIDToStringID(toolID); 
        //use this to compare against other tool codes
        var charID = typeIDToCharID(toolID); 
//        return (charID!=null && charID.length > 0) ? charID : stringID;;
        return [charID, stringID];
    }catch(err){
    }
}

//---------------------------
function ps_invoke_chc(url)
{
    var ad = new ActionDescriptor();
    ad.putString(stringIDToTypeID("helpID"), url); 
    executeAction(stringIDToTypeID("helpLauncher"), ad, DialogModes.NO);
}

function invoke_script_file(filepath) {
}

//---------------------------
function invoke_function_in_script_file(filepath, ns, functionName, arguments) {
}
function invoke_script(script)
{
}
function ps_invoke_script(script)
{
}
//---------------------------
function ps_invoke_action(actionSet, actionName)
{
//  var action = decode(actionName);
//  var group = decode(actionSet);
//  writelog("invoke action " + action + " " + group);
  ErrStrs = {}; 
  ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation"); 
  try 
  {
      app.doAction(actionName, actionSet);
//      app.doAction(action, group);
    } 
    catch(e)
    {
        if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;} 
        else
        {
            alert(actionSet + " : "+actionName + "\n" + localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
        }    
    }
}
//---------------------------
function ps_invoke_scritps_menu_item(item)
{
    var idAdobeScriptAutomationScripts = stringIDToTypeID( "AdobeScriptAutomation Scripts" );
    var desc2 = new ActionDescriptor();
    var idjsNm = charIDToTypeID( "jsNm" );
    desc2.putString( idjsNm, item ); // string for name of script in menu
    var idjsMs = charIDToTypeID( "jsMs" );
    desc2.putString( idjsMs, "undefined" );
    executeAction( idAdobeScriptAutomationScripts, desc2, DialogModes.NO );
}
//---------------------------
function invoke_feature_by_id(id)
{
    //alert("invoke feature by id " + id);
    $.evalFile(assetsPath + "/bundles/PHSP-14/feature.jsx");
    eval(id + "()");
}



function Main_Layer_New_Layer_via_Copy()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idCpTL = charIDToTypeID( 'CpTL' );
 executeAction( idCpTL, undefined, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Main_Edit_Transform_Warp()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc1062 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref836 = new ActionReference();
         var idMn = charIDToTypeID( 'Mn  ' );
         var idMnIt = charIDToTypeID( 'MnIt' );
         var idwarp = stringIDToTypeID( 'warp' );
         ref836.putEnumerated( idMn, idMnIt, idwarp );
     desc1062.putReference( idnull, ref836 );
 executeAction( idslct, desc1062, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Main_Layer_New_Adjustment_Layer_Curves()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idMk = charIDToTypeID( 'Mk  ' );
     var desc982 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref784 = new ActionReference();
         var idcontentLayer = stringIDToTypeID( 'contentLayer' );
         ref784.putClass( idcontentLayer );
     desc982.putReference( idnull, ref784 );
     var idUsng = charIDToTypeID( 'Usng' );
         var desc983 = new ActionDescriptor();
         var idType = charIDToTypeID( 'Type' );
         var idCrvs = charIDToTypeID( 'Crvs' );
         desc983.putClass( idType, idCrvs );
     var idcontentLayer = stringIDToTypeID( 'contentLayer' );
     desc982.putObject( idUsng, idcontentLayer, desc983 );
 executeAction( idMk, desc982, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Main_Edit_Fade()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idFade = charIDToTypeID( 'Fade' );
 executeAction( idFade, undefined, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Main_Filter_Liquify()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idLqFy = charIDToTypeID( 'LqFy' );
 executeAction( idLqFy, undefined, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Lasso_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc72 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref72 = new ActionReference();
         var idlassoTool = stringIDToTypeID( 'lassoTool' );
         ref72.putClass( idlassoTool );
     desc72.putReference( idnull, ref72 );
 executeAction( idslct, desc72, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Rectangular_Marquee_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc68 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref68 = new ActionReference();
         var idmarqueeRectTool = stringIDToTypeID( 'marqueeRectTool' );
         ref68.putClass( idmarqueeRectTool );
     desc68.putReference( idnull, ref68 );
 executeAction( idslct, desc68, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Pen_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc112 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref112 = new ActionReference();
         var idpenTool = stringIDToTypeID( 'penTool' );
         ref112.putClass( idpenTool );
     desc112.putReference( idnull, ref112 );
 executeAction( idslct, desc112, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Brush_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc92 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref92 = new ActionReference();
         var idPbTl = charIDToTypeID( 'PbTl' );
         ref92.putClass( idPbTl );
     desc92.putReference( idnull, ref92 );
 executeAction( idslct, desc92, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Clone_Stamp_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc96 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref96 = new ActionReference();
         var idClTl = charIDToTypeID( 'ClTl' );
         ref96.putClass( idClTl );
     desc96.putReference( idnull, ref96 );
 executeAction( idslct, desc96, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

function Tool_Healing_Brush_Tool()
{
ErrStrs = {};
 ErrStrs.USER_CANCELLED=localize("$$$/ScriptingSupport/Error/UserCancelled=User cancelled the operation");
 try {var idslct = charIDToTypeID( 'slct' );
     var desc88 = new ActionDescriptor();
     var idnull = charIDToTypeID( 'null' );
         var ref88 = new ActionReference();
         var idmagicStampTool = stringIDToTypeID( 'magicStampTool' );
         ref88.putClass( idmagicStampTool );
     desc88.putReference( idnull, ref88 );
 executeAction( idslct, desc88, DialogModes.ALL );
 } catch(e){if (e.toString().indexOf(ErrStrs.USER_CANCELLED)!=-1) {;
} else{alert(localize("$$$/ScriptingSupport/Error/CommandNotAvailable=The command is currently not available"));
}}}

